---
name: conflict-resolution
description: >
  Develop structured frameworks for analyzing and resolving interpersonal, organizational, or group conflicts. Use when navigating a dispute, mediation scenario, team tension, or negotiation breakdown. Triggers on "conflict resolution", "mediation", "resolve a dispute", "team conflict", or "diffuse a situation".
---

# Conflict Resolution

Your task is to develop a strategy for resolving conflicts by identifying core issues, understanding stakeholder interests, and facilitating open dialogue. The goal is to reduce tensions, build consensus, and create sustainable solutions addressing the root causes. Optional inputs refine the process based on context, objectives, and stakeholders.

## Required Inputs

1. **Conflict Scenario**: Describe the context (e.g., team dispute, client disagreement).
   - Establishes the foundation for analysis.

## Optional Inputs

1. **Objective**: Define the goal (e.g., restoring trust, reaching agreement).
   - Guides the resolution strategy.
2. **Stakeholders**: List involved parties (e.g., team members, clients).
   - Identifies perspectives to consider.
3. **History**: Provide background on past interactions.
   - Informs the process based on prior attempts.
4. **Focus Areas**: Highlight priorities (e.g., de-escalation, consensus-building).
   - Directs efforts toward specific conflict elements.

## Task Overview

Using provided inputs, craft a conflict resolution strategy for **[Conflict Scenario]**. Optional inputs refine the approach:

- **Objective** drives targeted outcomes.
- **Stakeholders** ensure comprehensive perspectives.
- **History** guides solutions by analyzing past failures.
- **Focus Areas** highlight priorities for resolution.

The strategy includes:

1. **Core Issue Identification**: Break down root causes.
2. **Stakeholder Analysis**: Understand interests and concerns.
3. **De-escalation Techniques**: Reduce tension to enable dialogue.
4. **Collaborative Problem-Solving**: Focus on shared interests.
5. **Consensus Building**: Secure sustainable agreements.
6. **Follow-Up Plan**: Ensure long-term adherence to solutions.

## Detailed Process Outline

### 1. Core Issue Identification
- **Root Cause Analysis**:
  - Use techniques like the "5 Whys" to identify root causes.
  - Review **History** if provided to understand recurring patterns.
- **Clarifying Perspectives**:
  - Align analysis with the **Objective**.

### 2. Stakeholder Analysis
- **Mapping Interests**:
  - Use empathy mapping for key **Stakeholders**.
  - Address power dynamics to balance communication.
- Prioritize concerns based on **Focus Areas**.

### 3. De-escalation Techniques
- **Active Listening & Empathy**:
  - Validate feelings to reduce defensiveness, especially with challenging **History**.
- **Tension Reduction**:
  - Focus on de-escalation if prioritized in **Focus Areas**.

### 4. Collaborative Problem-Solving
- **Common Interests**:
  - Align solutions with shared goals linked to the **Objective**.
- **Brainstorming**:
  - Involve **Stakeholders** to create feasible solutions.

### 5. Consensus Building
- **Agreement Facilitation**:
  - Use structured approaches for buy-in.
- Focus on long-term solutions if the **Objective** includes sustainability.

### 6. Follow-Up Plan
- **Monitoring**:
  - Regular check-ins to track progress based on the **Objective**.
- **Continuous Improvement**:
  - Adjust based on feedback and past **History**.
