---
name: future-scenarios
description: >
  Generate structured future scenarios and forecasts for a given topic, trend, or domain. Use when the user wants to explore plausible futures, stress-test strategies, or think through what-if scenarios.
---

Your task is to develop future scenarios for a specified topic, focusing on identifying risks, opportunities, and leverage points. The framework adapts to both minimal and detailed inputs, guiding robust forecasting and planning.

## Required Input

1. **Topic**: Define the primary subject or focus area for scenario planning (e.g., AI in healthcare, climate change policies).

## Optional Inputs

1. **Time Horizon**: Specify the timeframe for these scenarios (e.g., 5, 10, or 20 years).
   - Determines whether scenarios focus on short-term or long-term changes.
2. **Focus Areas**: Highlight specific aspects of interest (e.g., technology, regulations, social impact).
   - Helps concentrate the analysis on critical dimensions.
3. **Context**: Provide relevant background (e.g., current trends, known challenges).
   - Anchors scenarios in existing conditions for realistic projections.

## Task Overview

Using all provided inputs, develop four scenarios for **[Topic]**:

1. **Baseline**: Most likely future if current trends continue.
   - Incorporate Time Horizon and Context to project steady developments.
   - Focus on maintaining stability in identified Focus Areas.

2. **Best-Case**: Optimistic outcome where opportunities are maximized.
   - Show how leveraging key Focus Areas could lead to breakthroughs over the Time Horizon.
   - Use Context to identify strengths that can be expanded.

3. **Worst-Case**: Pessimistic outcome driven by amplified risks.
   - Analyze how current vulnerabilities worsen over the specified Time Horizon.
   - Address challenges from the Context that could derail progress.

4. **Wildcard**: A surprising but plausible disruption.
   - Explore sudden shifts outside the expected Context within the given Time Horizon.
   - Use Focus Areas to identify potential disruptors.

Each scenario should cover:

- **Key Drivers**: Factors influencing each scenario based on Focus Areas and Context.
- **Leverage Points**: Strategic interventions for impactful changes.
- **Impacts**: Potential effects on stakeholders and systems.
- **Recommendations**: Actions to optimize outcomes or mitigate risks.

### Additional Instructions

- If asked or given the command "help", provide a breakdown of the required and optional inputs along with examples.

## Detailed Process Outline

### 1. Scenario Development

- **Baseline Scenario**:
  - **Description**: Describe the most likely outcome if current trends continue without significant changes.
  - **Key Drivers**: Identify stable factors like existing regulations, societal attitudes, and technological trends supporting this trajectory.
  - **Leverage Points**: Highlight areas where small changes could maintain stability or enhance outcomes (e.g., regulatory updates, efficiency improvements).
- **Best-Case Scenario**:
  - **Description**: Envision a highly optimistic future where opportunities are maximized, and favorable conditions align.
  - **Key Drivers**: Identify breakthroughs, supportive policies, or shifts in consumer behavior driving this scenario.
  - **Leverage Points**: Pinpoint accelerators like investments in technology, incentivizing innovation, or streamlining processes.
- **Worst-Case Scenario**:
  - **Description**: Explore a pessimistic scenario where key risks materialize, and negative trends dominate.
  - **Key Drivers**: Focus on obstacles such as regulatory backlash, economic downturns, or technological failures.
  - **Leverage Points**: Identify interventions to mitigate negative impacts (e.g., risk management strategies, crisis response planning).
- **Wildcard Scenario**:
  - **Description**: Consider a surprising yet plausible outcome driven by sudden disruptions or black swan events.
  - **Key Drivers**: Speculate on unpredictable factors like geopolitical shifts, breakthrough discoveries, or societal upheavals.
  - **Leverage Points**: Focus on adaptability and resilience strategies to rapidly respond to unforeseen changes.

### 2. Risk Assessment Matrix

- **Purpose**: Systematically evaluate risks and opportunities based on their likelihood and potential impact on each scenario.
- **Implementation**:
  - For each scenario, list potential risks (e.g., regulatory hurdles, market shifts) and opportunities (e.g., technological innovations, partnerships).
  - Rate the probability and impact of each risk and opportunity.
  - Prioritize high-probability, high-impact items for immediate strategic focus.

### 3. Early Warning Indicators

- **Purpose**: Identify signs that indicate a particular scenario is unfolding.
- **Implementation**:
  - For each scenario, define measurable indicators (e.g., policy changes, market behaviors, technological adoption rates).
  - Establish specific triggers suggesting a shift towards a baseline, best-case, worst-case, or wildcard scenario.
  - Use these indicators to adapt strategies as new information emerges.

### 4. Feedback Loops Analysis

- **Purpose**: Understand self-reinforcing or self-correcting mechanisms within systems that could accelerate or hinder changes.
- **Implementation**:
  - Identify positive feedback loops (e.g., increased investments boosting tech adoption) or negative loops (e.g., public resistance slowing down innovation).
  - Assess how these loops can amplify or dampen the effects in each scenario.

### 5. Sensitivity Analysis

- **Purpose**: Examine how sensitive scenarios are to changes in key assumptions.
- **Implementation**:
  - Adjust critical variables (e.g., economic growth rates, policy changes, consumer behavior) to see how they affect scenario outcomes.
  - Identify the most sensitive variables with the greatest influence on each scenario.

### 6. Strategic Options Analysis

- **Purpose**: Provide actionable strategies based on leverage points identified in each scenario.
- **Implementation**:
  - Develop strategic options focusing on cost-effective, high-impact actions.
  - Tailor recommendations to optimize positive outcomes or address high-priority risks specific to each scenario.

## Output Template

**Time Horizon**: [5-10 years]
**Focus Areas**: [Technological advancements, regulations, ethics]
**Context**: [Current state, emerging trends]

### **[Name] Scenario**

- **Description**: [Outline the outcome.]
- **Key Drivers**: [Identify factors driving this scenario.]
- **Leverage Points**: [Highlight areas where small interventions can create change.]
- **Impacts**: [Describe the potential effects on the system.]
