---
name: humanizer
description: >
  Rewrite AI-generated or overly formal text to sound natural, warm, and authentically human. Use when content feels robotic, stiff, or templated and needs a more genuine voice. Triggers on "humanize", "rewrite this to sound human", "make this less AI", or "fix the tone".
---

# Humanizer

Your task is to transform and humanize any piece of writing, ensuring it is clear, direct, and engaging. The goal is to refine your source text by removing unnecessary words, avoiding marketing clichés, and adopting a natural, conversational tone. This framework is adaptable, incorporating optional inputs such as audience profile, tone/style preferences, key terms, or target length to shape the final output.

## Required Inputs

1. **Source Text or Message**
   - The draft or piece of writing you want to refine.

## Optional Inputs

1. **Audience Profile**
   - Who will read or use this text (e.g., general public, technical experts, internal team)?
2. **Tone/Style Preferences**
   - Any specific voice or style you're aiming for (e.g., casual, professional, empathetic).
3. **Key Terms or Phrases**
   - Essential words, phrases, or concepts that should remain prominent.
4. **Target Length**
   - Approximate word or character limit, if conciseness is a priority.

## Guidelines

1. **Focus on Clarity** – Make your message easy to understand.
2. **Be Direct and Concise** – Get straight to the point and remove unnecessary words.
3. **Use Simple Language** – Write plainly with short sentences; avoid dense or complex wording.
4. **Avoid Fluff** – Stay away from unnecessary adjectives and adverbs.
5. **Avoid Marketing Hype** – Don't over-promise or use promotional buzzwords.
6. **Keep It Real** – Be honest; avoid forced friendliness or exaggeration.
7. **Maintain a Natural/Conversational Tone** – It's okay to start sentences with "And" or "But".
8. **Simplify Grammar** – Don't stress about perfection; it's okay to be a bit informal if it matches your voice.
9. **Avoid AI-Giveaway Phrases** – Drop clichés like "dive into," "unleash your potential," etc.
10. **Vary Sentence Structures** – Combine short, medium, and long sentences for a natural flow.
11. **Address Readers Directly** – Use "you" and "your" to make the text more engaging.
12. **Use Active Voice** – Instead of "The report was submitted by the team," use "The team submitted the report."
13. **Avoid Filler Phrases** – Instead of "It's important to note that the deadline is approaching," use "The deadline is approaching."
14. **Remove Clichés, Jargon, Hashtags, Semicolons, Emojis, and Asterisks**.
15. **Minimize Conditional Language** – When sure, don't hedge with "could," "might," or "may."
16. **Eliminate Redundancy & Repetition** – Remove duplicate words or statements that don't add new value.
17. **Avoid Forced Keyword Placement** – Don't stuff keywords in ways that disrupt readability.

## Task Overview

Using the **Required** and any relevant **Optional** Inputs, transform or create a piece of writing that adheres to the **Guidelines** above. The objective is to produce text that is:

- **Clear**: Instantly understandable with minimal mental effort.
- **Concise**: Stripped of clutter and extraneous words.
- **Natural**: Feels human and conversational, rather than robotic or scripted.
- **Credible**: Free of hype or overused marketing terms.

## Detailed Process Outline

1. **Review Inputs** – Examine the **Source Text** and consider the **Audience Profile**, **Tone/Style Preferences**, and any **Key Terms**.
2. **Clarify Intent** – Confirm the main goal and identify critical points that must stay.
3. **Apply the Guidelines** – Work through each guideline systematically.
4. **Refine for Tone & Length** – If **Tone/Style Preferences** or **Target Length** are specified, adjust accordingly.
5. **Proof and Finalize** – Do a final read for clarity, flow, and adherence to the guidelines.

## Output Requirements

1. **Format**: Present the final text in paragraphs or bullet points as needed; keep punctuation minimal yet sufficient for clarity.
2. **Clarity**: No jargon, clichés, hashtags, emojis, or filler.
3. **Consistency**: Maintain a single style and consistent voice throughout.
4. **Conciseness**: Strive for the fewest words needed to convey each idea without losing meaning.
