---
name: idea-synthesis
description: >
  Synthesize multiple ideas, concepts, or inputs into a unified framework or coherent whole. Use when the user has gathered diverse perspectives, notes, or research and wants to extract common threads and generate insights.
---

Your task is to synthesize elements from multiple concepts, frameworks, or theories to develop cohesive new models. The goal is to blend these elements to highlight their complementary strengths, generating innovative solutions. This framework is adaptable, leveraging optional inputs to focus the synthesis on specific areas, contexts, and desired outcomes.

## Required Inputs

1. **Concepts**: List two or more concepts to synthesize (e.g., design thinking and Agile, Eastern philosophy and modern psychology).
   - Clearly define each concept to establish a foundation for integration.

## Optional Inputs

1. **Focus Areas**: Specify key aspects to prioritize (e.g., creativity, efficiency, user experience).
   - These will guide which principles are emphasized in the synthesis.
2. **Context**: Provide background on why these concepts are being integrated (e.g., improving team collaboration, enhancing innovation).
   - Helps align the synthesis with current challenges or industry-specific needs.
3. **Desired Outcomes**: Define the aim to achieve through the integration (e.g., a new project management method, a hybrid learning model).
   - Guides the synthesis towards meeting specific objectives.

## Task Overview

Using all provided inputs, develop a synthesized model that integrates **[Concepts]**. The optional inputs will shape the synthesis:

- **Focus Areas** will determine which principles to prioritize for integration.
- **Context** will ensure the synthesized model addresses relevant challenges or opportunities.
- **Desired Outcomes** will clarify the end goals, ensuring the final model aligns with your objectives.

The synthesis should include:

1. **Core Principles**: Extract and align fundamental principles from each concept based on the Focus Areas.
2. **Blended Approach**: Develop a cohesive framework that merges these principles, tailored to the Context provided.
3. **Unique Insights**: Highlight new strengths or advantages gained by integrating the concepts, aligned with the Desired Outcomes.
4. **Applications**: Identify practical use cases where this synthesized model can be effectively applied, considering the Context.

### Additional Instructions

- If asked or given the command "help", provide a breakdown of the required and optional inputs along with examples.
- Adapt the depth of analysis based on the level of detail provided in the inputs. If inputs are minimal, create a high-level synthesis; for detailed inputs, provide in-depth integration.
- If any critical inputs are missing or unclear, ask clarifying questions to ensure a thorough synthesis.
- Use structured formats (lists, diagrams) to clearly present the new model for easier understanding.

## Detailed Process Outline

### 1. Core Principles Extraction

- **Identify Core Elements**: Break down the main principles from each concept, focusing on Focus Areas.
- **Complementary Aspects**: Highlight synergistic principles that align with the specified Context.

### 2. Developing the Blended Approach

- **Integration Strategy**: Merge identified principles into a unified framework, considering the Desired Outcomes.
- **Structure**: Create a step-by-step outline to demonstrate how the new model functions in real-world scenarios.

### 3. Highlighting Unique Insights

- **Innovative Advantages**: Identify new solutions or strengths that emerge from the synthesis.
- **Value Proposition**: Emphasize how the integrated model achieves the specified Desired Outcomes more effectively than using the concepts independently.

### 4. Practical Applications

- **Use Cases**: Suggest practical scenarios where the new model can be applied, using the Context as a guide.
- **Real-World Examples**: Provide hypothetical or actual case studies to illustrate how the model addresses the specified Focus Areas.
- **Implementation Guidance**: Offer actionable steps for adopting the synthesized approach.

## Output Template

**Focus Areas**: [Focus Areas]
**Context**: Combining [Concept A] with [Concept B] to enhance [Desired Outcome]
**Desired Outcome**: [Desired Outcome]

### 1. Core Principles

- **Concept A**:
  - **Principle 1**: [Principle 1]
  - (Continue for each principle)
- **Concept B**:
  - **Principle 1**: [Principle 1]
  - (Continue for each principle)

### 2. Blended Approach

- **Integrated Framework**:
  - **Step 1**: Extract key strengths from Concept A and Concept B to address the specified Focus Areas.
  - **Step 2**: Identify overlapping principles and combine them into a unified methodology that aligns with the Desired Outcome.
  - **Step 3**: Adapt the synthesized approach to fit different contexts or use cases, ensuring flexibility and scalability.
- **Structure**:
  - **Phase 1**: Assess Core Elements → **Phase 2**: Integrate Complementary Strengths → **Phase 3**: Implement and Iterate Based on Feedback.

### 3. Unique Insights

- **Unique Insight 1**: [Briefly describe the unique insight]
- (Continue for each unique insight)

### 4. Applications

- **Application 1**: [Briefly describe the application]
- (Continue for each application)
