---
name: knowledge-review
description: >
  Review and summarize a knowledge domain, topic, or body of information. Use when the user wants a structured overview, key concepts, current state of knowledge, or gaps in a subject area.
---

Your task is to conduct a thorough review of existing knowledge on a specified topic, extracting key insights, identifying gaps, and suggesting areas for further exploration. The goal is to provide a comprehensive summary that can inform decision-making or guide future research. This framework is adaptable, integrating optional inputs to refine the review based on specific focus areas, context, and research questions.

## Required Inputs

1. **Topic**: Define the subject area for the review (e.g., artificial intelligence ethics, climate change adaptation).
   - Establishes the main focus for gathering insights.

## Optional Inputs

1. **Focus Areas**: Specify aspects to prioritize (e.g., technological advancements, policy implications).
   - Guides which subtopics and sections are emphasized.
2. **Context**: Provide background information or specify the purpose of the review (e.g., preparing a report, informing policy decisions).
   - Clarifies the angle or perspective, ensuring relevance.
3. **Research Questions**: List specific questions to be answered (e.g., What are the current challenges? What are the emerging opportunities?).
   - Directs the review to address targeted inquiries and uncover specific insights.

## Task Overview

Based on the provided inputs, conduct a comprehensive review of **[Topic]**. The optional inputs will shape the analysis as follows:

- **Focus Areas** refine the review, concentrating on the most critical subtopics.
- **Context** ensures the analysis aligns with the intended purpose or application.
- **Research Questions** guide the depth and direction of the review, ensuring key questions are addressed.

The review should include:

1. **Key Insights**: Extract significant findings, trends, and established knowledge relevant to the Focus Areas.
2. **Knowledge Gaps**: Identify areas where existing research is limited, aligning with the specified Research Questions.
3. **Applications**: Highlight practical implications or use cases based on the Context.
4. **Future Directions**: Suggest areas for further exploration, focusing on potential Desired Outcomes or impact.

### Additional Instructions

- If asked for "help" or more guidance, provide a breakdown of the required and optional inputs along with examples.
- Adjust the complexity based on the target audience: simplified explanations for non-experts or in-depth analysis for academic stakeholders.
- Highlight any significant debates, emerging trends, or pivotal studies related to the Context and Focus Areas.
- If any critical inputs are unclear, seek clarification to ensure a thorough and relevant review.

## Detailed Process Outline

### 1. Key Insights

- **Review Existing Research**
  - Summarize major findings and breakthroughs in the Focus Areas, considering the Context.
  - Highlight influential studies or models that address the Research Questions.
- **Emerging Trends**
  - Identify new developments or shifts in the field that align with the Focus Areas.
- **Significant Debates**
  - Note any ongoing controversies or conflicting perspectives, especially if they affect the Context.

### 2. Identifying Knowledge Gaps

- **Current Limitations**
  - Highlight areas where research is lacking, guided by the Research Questions.
  - Identify questions that remain unanswered, focusing on the Focus Areas.
- **Challenges**
  - Note barriers that limit understanding (e.g., theoretical gaps, data shortages).
- **Opportunities**
  - Point out where further research could have a significant impact, aligning with potential Desired Outcomes.

### 3. Practical Applications

- **Real-World Implications**
  - Illustrate how current insights can be applied to address challenges within the Context.
  - Provide examples of practical use cases relevant to the Focus Areas.
- **Use Cases**
  - Include case studies demonstrating successful applications in various sectors.
- **Policy Recommendations**
  - Suggest changes or initiatives based on research findings that align with the Context.

### 4. Future Directions

- **Potential Research Areas**
  - Propose topics for further investigation to fill the identified knowledge gaps.
- **Emerging Questions**
  - Highlight new questions that arise from recent studies, considering the Research Questions.
- **Innovative Approaches**
  - Recommend methodologies or interdisciplinary strategies that could advance the field, especially within the specified Focus Areas.

## Output Requirements

- **Format**: Use bullet points or structured lists for clarity.
- **Depth**: Provide multiple levels of detail (e.g., insights → gaps → future directions).
- **Definitions**: Include explanations of key terms to ensure clarity for non-experts.
- **Examples**: Use case studies or concrete illustrations to highlight findings where applicable.

## Output Template

```
## [Topic] Knowledge Review

**Focus Areas**: [Focus Areas]
**Context**: [Context]
**Research Questions**: [Research Questions]

### 1. Key Insights

- [Summarize major points or trends]

### 2. Knowledge Gaps

- [Identify where information is lacking or contradictory]

### 3. Applications

- [Highlight use cases or real-world implications]

### 4. Future Directions

- [Propose areas for further research or development]
```
