---
name: problem-solving
description: >
  Apply structured problem-solving frameworks to analyze a challenge and generate solutions. Use when the user has a specific problem, obstacle, or decision point and wants a systematic breakdown with actionable paths forward.
---

Your task is to break down complex problems into their root causes and propose actionable solutions. The goal is to identify key obstacles and provide practical, strategic steps to resolve them. This framework is adaptable, using optional inputs to refine the analysis based on context, focus areas, and desired outcomes.

## Required Inputs

1. **Problem**: Describe the main issue or challenge to address (e.g., declining customer engagement, supply chain disruptions).
   - Clearly define the problem to establish the scope of the analysis.

## Optional Inputs

1. **Context**: Provide relevant background information (e.g., recent changes, constraints, industry challenges).
   - Helps clarify the environment in which the problem exists, ensuring the analysis is grounded in real-world conditions.
2. **Focus Areas**: Specify key areas to prioritize (e.g., cost efficiency, team dynamics, technology adoption).
   - Directs the analysis towards the most critical concerns and areas for improvement.
3. **Desired Outcomes**: Define the goals to achieve (e.g., streamline processes, increase revenue, improve employee morale).
   - Guides the selection of solutions, aligning recommendations with objectives.

## Task Overview

Using all provided inputs, conduct a comprehensive problem analysis for **[Problem]**. The optional inputs will shape the analysis as follows:

- **Context** will inform the understanding of current challenges and constraints.
- **Focus Areas** will prioritize the aspects of the problem that need the most attention.
- **Desired Outcomes** will guide the development of solutions to align with specific objectives.

The analysis should include:

1. **Root Causes**: Identify underlying causes contributing to the problem, informed by the Context.
2. **Potential Solutions**: Propose actionable strategies targeting the root causes, focusing on the specified Focus Areas.
3. **Impact Analysis**: Assess the potential outcomes of each solution with respect to the Desired Outcomes.
4. **Recommendations**: Provide a prioritized set of actionable steps tailored to the Desired Outcomes.

### Additional Instructions

- If asked or given the command "help", provide a breakdown of the required and optional inputs along with examples.
- Adjust the depth of analysis based on the inputs provided. For broad problems with limited detail, focus on high-level strategies; for specific inputs, provide deeper, detailed solutions.
- Highlight potential risks, trade-offs, or unintended consequences associated with each proposed solution.
- If additional information is needed, ask targeted questions to refine the analysis.

## Detailed Process Outline

### 1. Root Cause Analysis

- **Problem Definition**:
  - Clearly define the problem, incorporating the provided Context.
- **Identify Causes**:
  - Break down the problem into its root causes, using tools like the "5 Whys" or Fishbone Diagram.
  - Categorize causes based on Focus Areas (e.g., internal inefficiencies, external market pressures).
- **Validation**:
  - Confirm root causes with data or case studies relevant to the Context.
  - Provide examples to support the analysis.

### 2. Potential Solutions

- **Develop Solutions**:
  - Brainstorm targeted solutions addressing each root cause, aligned with the Desired Outcomes.
  - Include both short-term fixes and long-term strategies to tackle identified issues.
- **Feasibility Assessment**:
  - Evaluate each solution's feasibility considering the Context (e.g., budget constraints, resource availability).
  - Highlight potential risks and challenges in implementation.
- **Examples**:
  - Use real-world or hypothetical examples to illustrate how solutions can be applied.

### 3. Impact Analysis

- **Assess Outcomes**:
  - Evaluate the potential impact of each solution on the overall system, considering the Desired Outcomes.
  - Analyze positive effects, potential risks, and unintended consequences.
- **Metrics for Success**:
  - Define key performance indicators (KPIs) that align with the Desired Outcomes.
  - Include metrics like cost reduction, productivity gains, or customer satisfaction improvements.

### 4. Recommendations

- **Prioritize Actions**:
  - Rank solutions based on their impact, feasibility, and alignment with the Desired Outcomes.
  - Focus on high-impact, low-effort solutions for quick wins.
- **Implementation Plan**:
  - Outline actionable steps for implementing the recommended solutions, tailored to the Context.
  - Include a timeline, resource allocation, and identification of responsible stakeholders.

## Output Requirements

- **Format**: Use structured lists, flowcharts, or tables to clearly present the analysis.
- **Depth**: Provide at least three levels of detail (e.g., Problem → Root Causes → Solutions).
- **Definitions**: Include concise explanations for each identified cause and proposed solution.
- **Examples**: Use case studies or examples to demonstrate how solutions can be practically applied.

## Output Template

**Context**: [Context]
**Focus Areas**: [Focus Areas]
**Desired Outcomes**: [Desired Outcomes]

### 1. Root Cause Analysis

- **Insight 1**: [Key finding or identified root cause].
- **Insight 2**: [Additional root cause or contributing factor].
- **Insight 3**: [Further relevant insight].

### 2. Potential Solutions

- **Solution 1**: [Description of how the insights can be addressed].
- **Solution 2**: [Another approach to resolving the problem].
- **Solution 3**: [Further practical solution].

### 3. Impact Analysis

- **Solution 1 Impact**: [Expected outcomes and effects].
- **Solution 2 Impact**: [Expected outcomes and effects].
- **Solution 3 Impact**: [Expected outcomes and effects].

### 4. Recommendations

- **Priority 1**: [Top recommended action with implementation steps].
- **Priority 2**: [Second priority action].
- **Priority 3**: [Additional recommended area to address].
