---
name: spectralith
description: >
  Generate surrealist, philosophical, or aesthetic image prompts using one of 10 named aesthetic frameworks (modes). Each mode is a distinct visual philosophy with 5 principles and 5 concepts per principle. Use when creating image prompts for AI image generation, art direction, or conceptual visual exploration. Trigger by naming a mode (e.g., "dream-logic prompt", "use artificial-naturalism", "give me a liminal-margins image") or by the aesthetic theme described. Available modes: artificial-naturalism, chronoptic-arcana, cognitive-dissonance, dream-logic, liminal-margins, mystic-paradox, perspective-alchemy, primordial-essence, sublime-absurdity, true-form.
---

## Overview

Spectralith is a library of 10 aesthetic frameworks for generating surrealist, philosophical, and visually compelling image prompts. Each framework is rooted in a distinct visual philosophy and consists of 5 core principles, with 5 concepts per principle—creating a coherent, systematic approach to image generation.

### The 10 Modes

1. **artificial-naturalism** — Synthesis of organic and mechanical aesthetics where nature and technology coexist seamlessly in poetic harmony.

2. **chronoptic-arcana** — Time as fluid and mystical, where past, present, and future fold into singular moments through cybernetic mythology and digital divinity.

3. **cognitive-dissonance** — Tension between conflicting ideas made visible through jarring juxtapositions, unfamiliar recontextualizations, and eerie contrasts.

4. **dream-logic** — Surreal dreamscapes where reality defies logic and the subconscious shapes form through morphing, whimsy, and symbolic imagery.

5. **liminal-margins** — Threshold spaces between states—transition, ambiguity, and in-between zones where forms hover on the verge of transformation.

6. **mystic-paradox** — Sacred and arcane imagery where opposites coexist, transcendence emerges from contradiction, and fragmentation creates hidden unity.

7. **perspective-alchemy** — Radical shifts in viewpoint and scale that transform how subjects are perceived, collapsing boundaries between microscopic and colossal.

8. **primordial-essence** — Raw, elemental forces and ancient patterns stripped to their most fundamental nature, celebrating wildness and cyclical decay.

9. **sublime-absurdity** — The beautiful and the ridiculous collide—grandeur meets the ludicrous through impossible physics and emotive incongruence.

10. **true-form** — Pure essence revealed by stripping away surface to expose underlying structure—clarity, perfection, and unchanging geometric absolutes.

---

## How to Use This Skill

1. **Specify a mode** by name (e.g., "generate a dream-logic prompt"), or describe the aesthetic theme you're exploring and I'll suggest an appropriate mode.

2. **Load the framework** from `references/[mode-name].md` to understand the mode's 5 principles and their 5 concepts.

3. **Apply the framework** — I will generate vivid, surreal image prompts shaped by that mode's visual philosophy and conceptual language.

4. **Generate prompts** using the unified output format (below).

---

## Image Prompt Format

For each prompt generated, the output will follow this structure:

### *[Artistic Title]*

Prompt:
```
[Image prompt — vivid, surreal, specific. Include lighting, texture, camera details, lens type, ISO, digital or film.]
```

Alt text:
```
[Short accessible description]
```

---

## General Image Prompt Guidelines

All modes follow these core principles when generating image prompts:

- **Vivid and Surreal Descriptions** — Use sensory language to create immersive, otherworldly imagery.

- **Highlight Contrasts or Paradoxes** — Emphasize tensions, juxtapositions, and philosophical contradictions central to the mode's aesthetics.

- **Specify Lighting and Textures** — Include details about light sources, material qualities, surfaces, and atmospheric conditions.

- **Dynamic and Fluid Elements** — Focus on movement, transformation, transitions, and elements that evoke flux or change.

- **Perspective and Scale Details** — Include information about viewpoint, focal length, proportion, and spatial relationships to create disorienting or wondrous effects.

- **Camera and Photographic Details** — Always specify lens type (e.g., 50mm, 24mm, 70mm), f-stop, ISO, and whether the image is digital or film-based.

---

## Loading the Framework

Before generating prompts, I will consult the relevant framework file from `references/[mode-name].md`. Each reference file contains:

- The mode's core philosophy statement
- 5 main principles
- 5 concepts per principle

These elements will inform the visual language, conceptual focus, and aesthetic direction of each generated prompt, ensuring consistency with the mode's philosophy.

---
