---
name: system-map
description: >
  Build a detailed structural map of any system — components, relationships, flows, inputs/outputs, and bottlenecks. Use when the user wants to understand, document, or optimize a workflow, process, organization, or complex system.
---

Your task is to develop a detailed, structured map of a specified system to reveal its components, relationships, and interdependencies. The goal is to optimize workflows, identify inefficiencies, and highlight areas for improvement. This framework handles both minimal and detailed inputs, enabling a thorough system analysis.

## Required Inputs

1. **System**: Specify the name or type of system to analyze (e.g., marketing workflow, supply chain management).
   - This defines the primary focus of the analysis.

## Optional Inputs

1. **Objective**: State the purpose of mapping this system (e.g., optimize efficiency, reduce bottlenecks).
   - Clarifies the desired outcome and informs the analysis direction.
2. **Scope**: Define boundaries (e.g., include external influences, focus on internal processes).
   - Helps refine what elements to include or exclude, shaping the overall system map.
3. **Stakeholders**: List key individuals or groups involved (e.g., clients, managers, vendors).
   - Identifies who is impacted by the system, which influences both system flows and areas for optimization.
4. **Context**: Provide relevant background or challenges (e.g., recent changes, known inefficiencies).
   - Ensures that the analysis is aligned with current conditions and existing issues, providing deeper insights.
5. **Focus Areas**: Highlight specific elements of interest (e.g., communication flows, data processing).
   - Prioritizes critical elements to target during the mapping process, allowing for a more customized approach.

## Task Overview

Using the provided inputs, develop a comprehensive system map for **[System]** with the following structure:

1. **Core Components**: Break down the system into its main components and subsystems. Use the Scope input to determine what should be included.
2. **Relationships**: Illustrate interactions, dependencies, and feedback loops, especially where Stakeholders and Focus Areas intersect.
3. **Processes & Flows**: Identify key workflows, data exchanges, and communication pathways, optimizing for the Objective specified.
4. **Inputs & Outputs**: Define key resources, data, or stakeholders entering and exiting the system based on the Context provided.
5. **Bottlenecks & Opportunities**: Highlight inefficiencies informed by the Context and Focus Areas to suggest improvements.

### Additional Instructions

- If asked or given the command "help", provide a breakdown of the required and optional inputs along with examples.
- Use the Objective to adjust the depth of analysis, tailoring recommendations to meet the specified goals.
- Leverage Stakeholders to identify potential impacts of changes and to communicate effectively with those involved.
- Adapt the complexity based on the system's nature and target audience, using a high-level overview if addressing non-technical stakeholders.
- If inputs are missing or unclear, request additional information to ensure a thorough and accurate map.

## Detailed Process Outline

### 1. System Breakdown

- **Core Components**:
  - List all major components and subsystems, categorized by function.
  - Include brief definitions to clarify the role of each component.
- **Subsystem Analysis**:
  - Break down subsystems into key processes.
  - Provide examples to demonstrate how they operate.

### 2. Mapping Relationships & Interactions

- **Dependencies**:
  - Illustrate how components interact and depend on each other.
  - Highlight feedback loops that influence system behavior.
- **Flows**:
  - Map the flow of data, resources, or information between components.
  - Identify critical pathways essential for system performance.

### 3. Inputs & Outputs

- **Definition**: Identify key resources, data, or people entering and exiting the system.
- **Sources & Destinations**:
  - Map where inputs come from and where outputs are directed.
  - Include internal and external factors influencing the system.

### 4. Bottlenecks & Opportunities

- **Inefficiencies**: Identify bottlenecks slowing down the system.
- **Optimization**:
  - Suggest improvements, such as automation or resource reallocation.
  - Provide strategies for enhancing overall performance.

## Output Template

**Objective**: [Define the main goal, e.g., streamline operations, reduce costs]
**Scope**: [Clarify boundaries, e.g., focus on internal workflows, include external partners]
**Stakeholders**: [List key groups, e.g., department heads, clients, suppliers]
**Context**: [Highlight current challenges, e.g., inefficiencies, recent system updates]

### 1. Core Components

- **[Component 1]**: [Brief description of its function]
  - **Process 1**: [Detail a specific process, e.g., data collection]
  - (Continue for each process)
- (Continue for each component)

### 2. Relationships & Interactions

- **Data Flow**: [Describe the movement of information, e.g., from collection to analysis, then reporting].
- **Feedback Loop**: [Highlight any feedback processes, e.g., continuous improvement based on performance metrics].
- **Collaboration Pathways**: [Identify areas requiring frequent interdepartmental communication].

### 3. Inputs & Outputs

- **Inputs**: [Identify key inputs, e.g., customer orders, market research, raw materials].
- **Outputs**: [List main outputs, e.g., finished products, customer reports, performance analytics].

### 4. Bottlenecks & Opportunities

- **Current Bottlenecks**: [Highlight issues, e.g., approval delays, resource shortages].
- **Opportunities**:
  - [Opportunity 1]: [Describe potential solution, e.g., automate manual processes].
  - (Continue for each opportunity)
