---
name: topic-structure
description: >
  Create a structured outline or taxonomy for any topic, subject, or domain. Use when the user wants to organize a body of knowledge, build a curriculum, or create a hierarchical breakdown of a complex subject.
---

Your task is to develop a structured taxonomy for a given topic, organizing its concepts into categories, subcategories, and detailed topics. The goal is to create a clear and comprehensive hierarchy that highlights relationships and simplifies complex information. This framework handles both minimal and detailed inputs to shape the taxonomy.

## Required Inputs

1. **Topic**: Define the main subject to structure (e.g., data science, environmental sustainability).
   - This sets the foundation for building the taxonomy.

## Optional Inputs

1. **Focus Areas**: Specify areas to emphasize within the topic (e.g., methodologies, technologies, social impacts).
   - Guides which sections of the taxonomy to prioritize for deeper granularity.
2. **Context**: Provide background information or specify the purpose of the taxonomy (e.g., for educational content, strategic planning).
   - Clarifies how the taxonomy will be used, ensuring relevance to the intended audience.
3. **Frameworks**: Mention any specific frameworks or theories to incorporate (e.g., Agile methodologies, Maslow's hierarchy).
   - Ensures alignment with established structures and frameworks.

## Task Overview

Using all provided inputs, create a comprehensive taxonomy for **[Topic]**. The optional inputs will shape the structure as follows:

- **Focus Areas** will help prioritize which categories and subcategories to emphasize.
- **Context** will guide the overall structure to align with the intended application.
- **Frameworks** will inform how the taxonomy is structured, ensuring consistency with existing theories.

The taxonomy should include:

1. **Categories**: Break down the Topic into broad categories based on the Focus Areas.
2. **Subcategories**: Further refine each category into specific subcategories, guided by the Context.
3. **Topics**: Include detailed topics under each subcategory, incorporating elements from the specified Frameworks if provided.
4. **Relationships**: Highlight overlaps or connections between categories, especially where Frameworks influence multiple areas.

### Additional Instructions

- If asked or given the command "help", provide a breakdown of the required and optional inputs along with examples.
- Adjust complexity based on your target audience's familiarity with the topic. Simplify for non-experts or provide deeper details for specialists.
- Emphasize relationships between categories, especially where overlapping areas are identified through the Focus Areas.
- If any input is unclear or missing, ask targeted questions to refine the taxonomy.

## Detailed Process Outline

### 1. Structuring the Taxonomy

- **Categories**:
  - Identify the broad categories that cover the major aspects of the Topic, tailored to the Focus Areas.
  - Include definitions to clarify the scope of each category, especially in relation to the Context.
- **Subcategories**:
  - Break down each category into subcategories, using the Context to ensure they are relevant to the intended purpose.
  - Leverage the provided Frameworks to align subcategories where applicable.
- **Topics**:
  - List detailed topics under each subcategory, informed by the Focus Areas and aligned with any specified Frameworks.
  - Include descriptions to explain the significance of each topic.

### 2. Highlighting Relationships

- **Cross-Connections**:
  - Identify overlaps between categories where topics or methods intersect, guided by the Focus Areas.
  - Highlight dependencies or complementary areas where concepts overlap, aligning with the Context.
- **Hierarchy**:
  - Use a nested structure to show how categories, subcategories, and topics relate to each other.
  - Consider visual aids like hierarchical lists or tree diagrams to enhance clarity.

### 3. Refinement and Validation

- **Consistency Check**:
  - Ensure all categories, subcategories, and topics are clearly defined and non-redundant.
- **Alignment with Frameworks**:
  - Verify that the taxonomy aligns with any provided Frameworks.
- **Feedback Loop**:
  - Refine the taxonomy based on additional feedback or updates to the Context or Focus Areas.

## Output Requirements

- **Format**: Use nested lists or a hierarchical tree structure for clarity.
- **Depth**: Include at least three levels of detail (e.g., Categories → Subcategories → Topics).
- **Definitions**: Provide brief descriptions to clarify each category and subcategory.
- **Examples**: Use case studies or examples to demonstrate practical applications, especially where relevant to the Context.

## Output Template

**Focus Areas**: [Focus Areas]
**Context**: [Context, e.g., for strategic planning, educational content]
**Frameworks**: [Frameworks, if any, e.g., Agile methodology, Lean principles]

### 1. Categories

1. **[Category 1]**
   1.1. **[Subcategory 1.1]:** [Brief description of Subcategory 1.1]
      - [Topic 1]: [Brief description of Topic 1]
      - (Continue for each topic)
   1.2. (Continue for each subcategory)
2. (Continue for each category)

### 2. Relationships

- **Cross-Connections**:
  - (List cross-connections, e.g., **[Category X]** influences **[Category Y]** through shared techniques or tools.)
  - (Continue for each cross-connection)
- **Dependencies**:
  - (List dependencies, e.g., **[Subcategory A]** depends on foundational work from **[Subcategory B]** to optimize outcomes.)
  - (Continue for each dependency)
